// Made by Hobbes 2005 hobbes.hetsoet.nl //

var DigitImage;
var TimerId = null;
var TimerIdValid = 0;
var LastSecond = -1;
var hidden = false;
var modus = 24;

function idiv (n, d)
{ 
  return Math.floor(n / d);
}

function PreLoadImages () {
    var i;
    DigitImage = new Array;
    for (i = 0; i < 10; i++) {
        DigitImage[i] = new Image;
        DigitImage[i].src = "Timer" + i + ".png";
    }
}

function Digit (n, i) {
    while (--i > 0) {
        n = Math.floor(n / 10);
    }
    return DigitImage[n % 10].src;
}

function DisplayTime () {

    // Get current time (millisecond resolution).
    var local = new Date();

	if (local.getHours() != 12) {
		local.setHours(local.getHours() % modus);
	}

    // Avoid re-display if seconds haven't changed.
    var second = local.getSeconds();
    if (second == LastSecond) {
        return;
    }
    LastSecond = second;

    var n;
    var d = document;

    var dpcnt = (second % 2);
    if (!dpcnt) {
      d.d2.src = "Timer.png";
    } else {
      d.d2.src = "timerdot.png";
    }
    // Display local time.

    d.h2.src = Digit(local.getHours(), 2);
    d.h1.src = Digit(local.getHours(), 1);

    d.m2.src = Digit(local.getMinutes(), 2);
    d.m1.src = Digit(local.getMinutes(), 1);

    var seconds = local.getSeconds();
    d.s2.src = Digit(seconds, 2);
    d.s1.src = Digit(seconds, 1);
}


function onshow() {
  hidden = false;
  TimerThread();
}

function onhide() {
  hidden = true;
}

function TimerThread () {
  if (!hidden) {
    if (TimerIdValid) {
      clearTimeout(TimerId);
      TimerIdValid = 0;
    }
    DisplayTime();
    TimerId = setTimeout("TimerThread()", 100);
    TimerIdValid = 1;
  }
}


if (window.widget) {
    widget.onhide = onhide;
    widget.onshow = onshow;
}

//  Dashboard Code (from apple)
function setup() {
	createGenericButton(document.getElementById('done'), 'done', hidePrefs);
	widget.setCloseBoxOffset(16,4);
}

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToBack");
       
	front.style.display="none";
	back.style.display="block";
	exitflip(event);

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);  
}

function hidePrefs()
{
	SetBackground();
	if (document.getElementById("modus").checked == true) {
		widget.setPreferenceForKey(24, "Modus");
		modus = 24;
	} else {
		widget.setPreferenceForKey(12, "Modus");
		modus = 12;
	}
	document.getElementById("done").src = "Done.png";
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToFront");
      
	back.style.display="none";
	front.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 50);
}

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
	if (!flipShown)
	{
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
 
		var starttime = (new Date).getTime() - 13;
 
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}
function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}

		var starttime = (new Date).getTime() - 13;

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
   

	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c)
{
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
	return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function onmousedowndone () {
	document.getElementById("done").src = "Done Pressed.png";
}

function onmouseoutdone () {
	document.getElementById("done").src = "Done.png";
}

function SetBackground () {
	var color = document.getElementById("colors").selectedIndex;
	widget.setPreferenceForKey(color, "Color");
	if (color == 0) {
		document.getElementById("background").src = "Black.png";
	} else if (color == 1) {
		document.getElementById("background").src = "Default.png";
	} else if (color == 2) {
		document.getElementById("background").src = "Bordeaux.png";
	} else if (color == 3) {
		document.getElementById("background").src = "Brown.png";
	} else if (color == 4) {
		document.getElementById("background").src = "Gray.png";
	} else if (color == 5) {
		document.getElementById("background").src = "Green.png";
	} else if (color == 6) {
		document.getElementById("background").src = "Orange.png";
	} else if (color == 7) {
		document.getElementById("background").src = "Purple.png";
	} else if (color == 8) {
		document.getElementById("background").src = "Red.png";
	} else if (color == 9) {
		document.getElementById("background").src = "Rose.png";
	} else if (color == 10) {
		document.getElementById("background").src = "Turkoise.png";
	} else if (color == 11) {
		document.getElementById("background").src = "Yellow.png";
	}
}